*********************************************************************** 
11/24/12: CREATED TO BE USED FOR DATA FOR MIDDLE CLASS WELL-BEING PROJECT

***********************************************************************;
OPTIONS NOLABEL;

LIBNAME vlad '~/jim/data';
LIBNAME alldat '~/jim/data';

* NOTE, IN 80-81, PROPVALU IS IN FAMILY FILE, NOT MTAB;

filename mtab841 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0003-Data.txt.gz';
filename mtab842 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0007-Data.txt.gz';
filename mtab843 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0011-Data.txt.gz';
filename mtab844 pipe 'gunzip -c ~/jim/data/ce_mtab/1984/08671-0015-Data.txt.gz';

filename mtab851 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0003-Data.txt.gz';
filename mtab852 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0007-Data.txt.gz';
filename mtab853 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0011-Data.txt.gz';
filename mtab854 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0015-Data.txt.gz';
filename mtab855 pipe 'gunzip -c ~/jim/data/ce_mtab/1985/08904-0019-Data.txt.gz';
 
filename mtab861 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0003-Data.txt.gz';
filename mtab862 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0007-Data.txt.gz';
filename mtab863 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0011-Data.txt.gz';
filename mtab864 pipe 'gunzip -c ~/jim/data/ce_mtab/1986/09113-0015-Data.txt.gz';
 
filename mtab871 pipe 'gunzip -c ~/jim/data/ce_mtab/1987/09332-0003-Data.txt.gz';
filename mtab872 pipe 'gunzip -c ~/jim/data/ce_mtab/1987/09332-0007-Data.txt.gz';
filename mtab873 pipe 'gunzip -c ~/jim/data/ce_mtab/1987/09332-0011-Data.txt.gz';
filename mtab874 pipe 'gunzip -c ~/jim/data/ce_mtab/1987/09332-0015-Data.txt.gz';

filename mtab881 pipe 'gunzip -c ~/jim/data/ce_mtab/1988/09451-0003-Data.txt.gz';
filename mtab882 pipe 'gunzip -c ~/jim/data/ce_mtab/1988/09451-0007-Data.txt.gz';
filename mtab883 pipe 'gunzip -c ~/jim/data/ce_mtab/1988/09451-0011-Data.txt.gz';
filename mtab884 pipe 'gunzip -c ~/jim/data/ce_mtab/1988/09451-0015-Data.txt.gz';
 
filename mtab891 pipe 'gunzip -c ~/jim/data/ce_mtab/1989/09712-0003-Data.txt.gz';
filename mtab892 pipe 'gunzip -c ~/jim/data/ce_mtab/1989/09712-0007-Data.txt.gz';
filename mtab893 pipe 'gunzip -c ~/jim/data/ce_mtab/1989/09712-0011-Data.txt.gz';
filename mtab894 pipe 'gunzip -c ~/jim/data/ce_mtab/1989/09712-0015-Data.txt.gz';
 
filename mtab901 pipe 'gunzip -c ~/jim/data/ce_mtab/1990/09820-0003-Data.txt.gz';
filename mtab902 pipe 'gunzip -c ~/jim/data/ce_mtab/1990/09820-0007-Data.txt.gz';
filename mtab903 pipe 'gunzip -c ~/jim/data/ce_mtab/1990/09820-0011-Data.txt.gz';
filename mtab904 pipe 'gunzip -c ~/jim/data/ce_mtab/1990/09820-0015-Data.txt.gz';
 
filename mtab911 pipe 'gunzip -c ~/jim/data/ce_mtab/1991/06209-0003-Data.txt.gz';
filename mtab912 pipe 'gunzip -c ~/jim/data/ce_mtab/1991/06209-0007-Data.txt.gz';
filename mtab913 pipe 'gunzip -c ~/jim/data/ce_mtab/1991/06209-0011-Data.txt.gz';
filename mtab914 pipe 'gunzip -c ~/jim/data/ce_mtab/1991/06209-0015-Data.txt.gz';

filename mtab921 pipe 'gunzip -c ~/jim/data/ce_mtab/1992/06372-0003-Data.txt.gz';
filename mtab922 pipe 'gunzip -c ~/jim/data/ce_mtab/1992/06372-0007-Data.txt.gz';
filename mtab923 pipe 'gunzip -c ~/jim/data/ce_mtab/1992/06372-0011-Data.txt.gz';
filename mtab924 pipe 'gunzip -c ~/jim/data/ce_mtab/1992/06372-0015-Data.txt.gz';
 
filename mtab931 pipe 'gunzip -c ~/jim/data/ce_mtab/1993/da6580.mtab.q931.gz';   
filename mtab932 pipe 'gunzip -c ~/jim/data/ce_mtab/1993/da6580.mtab.q932.gz';   
filename mtab933 pipe 'gunzip -c ~/jim/data/ce_mtab/1993/da6580.mtab.q933.gz';   
filename mtab934 pipe 'gunzip -c ~/jim/data/ce_mtab/1993/da6580.mtab.q934.gz';      
 
filename mtab941 pipe 'gunzip -c ~/jim/data/ce_mtab/1994/da6710.mtab.q941.gz';      
filename mtab942 pipe 'gunzip -c ~/jim/data/ce_mtab/1994/da6710.mtab.q942.gz';      
filename mtab943 pipe 'gunzip -c ~/jim/data/ce_mtab/1994/da6710.mtab.q943.gz';   
filename mtab944 pipe 'gunzip -c ~/jim/data/ce_mtab/1994/da6710.mtab.q944.gz';      
 
filename mtab951 pipe 'gunzip -c ~/jim/data/ce_mtab/1995/da2264.mtab.q951.gz';      
filename mtab952 pipe 'gunzip -c ~/jim/data/ce_mtab/1995/da2264.mtab.q952.gz';      
filename mtab953 pipe 'gunzip -c ~/jim/data/ce_mtab/1995/da2264.mtab.q953.gz';      
filename mtab954 pipe 'gunzip -c ~/jim/data/ce_mtab/1995/da2264.mtab.q954.gz';   
filename mtab955 pipe 'gunzip -c ~/jim/data/ce_mtab/1995/da2264.mtab.q955.gz';
 
filename mtab961 pipe 'gunzip -c ~/jim/data/ce_mtab/1996/02794-0003-Data.txt.gz';
filename mtab962 pipe 'gunzip -c ~/jim/data/ce_mtab/1996/02794-0007-Data.txt.gz';
filename mtab963 pipe 'gunzip -c ~/jim/data/ce_mtab/1996/02794-0011-Data.txt.gz';
filename mtab964 pipe 'gunzip -c ~/jim/data/ce_mtab/1996/02794-0015-Data.txt.gz';
 
filename mtab971 pipe 'gunzip -c ~/jim/data/ce_mtab/1997/mtabi971X.txt.gz';      
filename mtab972 pipe 'gunzip -c ~/jim/data/ce_mtab/1997/mtabi972.txt.gz'; 
filename mtab973 pipe 'gunzip -c ~/jim/data/ce_mtab/1997/mtabi973.txt.gz'; 
filename mtab974 pipe 'gunzip -c ~/jim/data/ce_mtab/1997/mtabi974.txt.gz';
 
filename mtab981 pipe 'gunzip -c ~/jim/data/ce_mtab/1998/da2971.mtab981.gz';     
filename mtab982 pipe 'gunzip -c ~/jim/data/ce_mtab/1998/da2971.mtab982.gz';     
filename mtab983 pipe 'gunzip -c ~/jim/data/ce_mtab/1998/da2971.mtab983.gz';     
filename mtab984 pipe 'gunzip -c ~/jim/data/ce_mtab/1998/da2971.mtab984.gz';

filename mtab991 pipe 'gunzip -c ~/jim/data/ce_mtab/1999/da3228.mtab991.gz';
filename mtab992 pipe 'gunzip -c ~/jim/data/ce_mtab/1999/da3228.mtab992.gz'; 
filename mtab993 pipe 'gunzip -c ~/jim/data/ce_mtab/1999/da3228.mtab993.gz'; 
filename mtab994 pipe 'gunzip -c ~/jim/data/ce_mtab/1999/da3228.mtab994.gz'; 
 
filename mtab1001 pipe 'gunzip -c ~/jim/data/ce_mtab/2000/da3396.mtab001.gz';
filename mtab1002 pipe 'gunzip -c ~/jim/data/ce_mtab/2000/da3396.mtab002.gz';
filename mtab1003 pipe 'gunzip -c ~/jim/data/ce_mtab/2000/da3396.mtab003.gz';
filename mtab1004 pipe 'gunzip -c ~/jim/data/ce_mtab/2000/da3396.mtab004.gz';
 
filename mtab1011 pipe 'gunzip -c ~/jim/data/ce_mtab/2001/da3674.mtab011.gz';
filename mtab1012 pipe 'gunzip -c ~/jim/data/ce_mtab/2001/da3674.mtab012.gz';
filename mtab1013 pipe 'gunzip -c ~/jim/data/ce_mtab/2001/da3674.mtab013.gz';
filename mtab1014 pipe 'gunzip -c ~/jim/data/ce_mtab/2001/da3674.mtab014.gz';
 
filename mtab1021 pipe 'gunzip -c ~/jim/data/ce_mtab/2002/03949-0003-Data.txt.gz';
filename mtab1022 pipe 'gunzip -c ~/jim/data/ce_mtab/2002/03949-0007-Data.txt.gz';
filename mtab1023 pipe 'gunzip -c ~/jim/data/ce_mtab/2002/03949-0011-Data.txt.gz';
filename mtab1024 pipe 'gunzip -c ~/jim/data/ce_mtab/2002/03949-0015-Data.txt.gz';
 
filename mtab1031 pipe 'gunzip -c ~/jim/data/ce_mtab/2003/mtabi031x.txt.gz';
filename mtab1032 pipe 'gunzip -c ~/jim/data/ce_mtab/2003/mtabi032.txt.gz'; 
filename mtab1033 pipe 'gunzip -c ~/jim/data/ce_mtab/2003/mtabi033.txt.gz';
filename mtab1034 pipe 'gunzip -c ~/jim/data/ce_mtab/2003/mtabi034.txt.gz';

filename mtab1041 pipe 'gunzip -c ~/jim/data/ce_mtab/2004/mtabi041x.txt.gz'; 
filename mtab1042 pipe 'gunzip -c ~/jim/data/ce_mtab/2004/mtabi042.txt.gz';  
filename mtab1043 pipe 'gunzip -c ~/jim/data/ce_mtab/2004/mtabi043.txt.gz';  
filename mtab1044 pipe 'gunzip -c ~/jim/data/ce_mtab/2004/mtabi044.txt.gz';  
filename mtab1045 pipe 'gunzip -c ~/jim/data/ce_mtab/2004/mtabi051.txt.gz';
 
filename mtab1051 pipe 'gunzip -c ~/jim/data/ce_mtab/2005/mtabi051x.txt.gz'; 
filename mtab1052 pipe 'gunzip -c ~/jim/data/ce_mtab/2005/mtabi052.txt.gz';  
filename mtab1053 pipe 'gunzip -c ~/jim/data/ce_mtab/2005/mtabi053.txt.gz';  
filename mtab1054 pipe 'gunzip -c ~/jim/data/ce_mtab/2005/mtabi054.txt.gz';

filename mtab1061 pipe 'gunzip -c ~/jim/data/ce_mtab/2006/mtabi061x.txt.gz';
filename mtab1062 pipe 'gunzip -c ~/jim/data/ce_mtab/2006/mtabi062.txt.gz'; 
filename mtab1063 pipe 'gunzip -c ~/jim/data/ce_mtab/2006/mtabi063.txt.gz'; 
filename mtab1064 pipe 'gunzip -c ~/jim/data/ce_mtab/2006/mtabi064.txt.gz';
    
filename mtab1071 pipe 'gunzip -c ~/jim/data/ce_mtab/2007/mtabi071x.txt.gz';
filename mtab1072 pipe 'gunzip -c ~/jim/data/ce_mtab/2007/mtabi072.txt.gz';
filename mtab1073 pipe 'gunzip -c ~/jim/data/ce_mtab/2007/mtabi073.txt.gz';
filename mtab1074 pipe 'gunzip -c ~/jim/data/ce_mtab/2007/mtabi074.txt.gz';
   
filename mtab1081 pipe 'gunzip -c ~/jim/data/ce_mtab/2008/mtabi081x.txt.gz';
filename mtab1082 pipe 'gunzip -c ~/jim/data/ce_mtab/2008/mtabi082.txt.gz';
filename mtab1083 pipe 'gunzip -c ~/jim/data/ce_mtab/2008/mtabi083.txt.gz';
filename mtab1084 pipe 'gunzip -c ~/jim/data/ce_mtab/2008/mtabi084.txt.gz';

filename mtab1091 pipe 'gunzip -c ~/jim/data/ce_mtab/2009/mtabi091x.txt.gz';
filename mtab1092 pipe 'gunzip -c ~/jim/data/ce_mtab/2009/mtabi092.txt.gz';
filename mtab1093 pipe 'gunzip -c ~/jim/data/ce_mtab/2009/mtabi093.txt.gz';
filename mtab1094 pipe 'gunzip -c ~/jim/data/ce_mtab/2009/mtabi094.txt.gz';

filename mtab1101 pipe 'gunzip -c ~/jim/data/ce_mtab/2010/mtabi101x.txt.gz';
filename mtab1102 pipe 'gunzip -c ~/jim/data/ce_mtab/2010/mtabi102.txt.gz';
filename mtab1103 pipe 'gunzip -c ~/jim/data/ce_mtab/2010/mtabi103.txt.gz';
filename mtab1104 pipe 'gunzip -c ~/jim/data/ce_mtab/2010/mtabi104.txt.gz';

FILENAME mtab1111 '~/jim/data/ce_mtab/2011/mtbi111x.csv';
FILENAME mtab1112 '~/jim/data/ce_mtab/2011/mtbi112.csv';
FILENAME mtab1113 '~/jim/data/ce_mtab/2011/mtbi113.csv';
FILENAME mtab1114 '~/jim/data/ce_mtab/2011/mtbi114.csv';
FILENAME mtab1115 '~/jim/data/ce_mtab/2011/mtbi121.csv';


%MACRO read(qyr); 
 
  DATA exp&qyr;
   INFILE mtab&qyr ; 
   IF 801 LE &qyr LE 955 THEN INPUT newid 1-8 ucc 9-14 cost 15-26 cost_ $ 27 ref_mo 30-31 ref_yr 32-33;
   IF &qyr GE 961 THEN INPUT newid 1-8 ucc 9-14 cost 15-26 cost_ $ 27 ref_mo 30-31 ref_yr 32-35;

   IF ucc=800721;

   qyear=&qyr; 
   IF qyear LE 855 THEN newid=9000000+newid;
	

   numhous=1; 
   *prop values are at monthly level, so multiply by 4 and sum across the 3 months;
   propvalu=cost*4;

  RUN;

PROC SORT DATA=exp&qyr; 
   BY newid;
RUN; 
PROC MEANS DATA=exp&qyr SUM NOPRINT;
     BY newid;
     ID qyear;
     VAR numhous propvalu;
     OUTPUT OUT=out_h&qyr(DROP=_FREQ_ _TYPE_) SUM=n_hous totpval;
RUN;  
PROC MEANS; 
RUN; 
%MEND read; 



* FOR SURVEY YEARS 2011 AND AFTER;
%MACRO read2(qyr);

PROC IMPORT DATAFILE=mtab&qyr
     OUT=exp&qyr
     DBMS=CSV
     REPLACE;
     GETNAMES=YES;
RUN;
 
DATA exp&qyr; 
   SET exp&qyr; 
   
   IF ucc="800721";

   qyear=&qyr; 
   
   numhous=1; 
   *prop values are at monthly level, so multiply by 4 and sum across the 3 months;
   propvalu=cost*4;

   KEEP newid numhous propvalu qyear ;

RUN;
  
PROC SORT DATA=exp&qyr; 
   BY newid;
RUN; 
PROC MEANS DATA=exp&qyr SUM NOPRINT;
     BY newid;
     ID qyear;
     VAR numhous propvalu;
     OUTPUT OUT=out_h&qyr(DROP=_FREQ_ _TYPE_) SUM=n_hous totpval;
RUN;  
PROC MEANS; 
RUN; 

%MEND read2;



%read(841);
%read(842);    
%read(843);
%read(844);
 
%read(851);
%read(852);    
%read(853); 
%read(854);   
 
%read(861); 
%read(862);
%read(863);
%read(864); 

%read(871);
%read(872); 
%read(873);   
%read(874);
 
%read(881);    
%read(882); 
%read(883);
%read(884);
 
%read(891);
%read(892); 
%read(893);
%read(894);  
 
%read(901); 
%read(902);
%read(903);
%read(904); 
 
%read(911);    
%read(912); 
%read(913);   
%read(914);
 
%read(921);    
%read(922);
%read(923);
%read(924);
 
%read(931);    
%read(932); 
%read(933);   
%read(934); 

%read(941);   
%read(942); 
%read(943);  
%read(944); 
 
%read(951);
%read(952);
%read(953);
%read(954); 
%read(955); 
      
%read(961); 
%read(962);  
%read(963); 
%read(964);
 
%read(971);
%read(972);
%read(973); 
%read(974);
 
%read(981); 
%read(982);  
%read(983); 
%read(984);
 
%read(991);
%read(992);
%read(993); 
%read(994);   
      
%read(1001); 
%read(1002);  
%read(1003); 
%read(1004);

%read(1011);
%read(1012);
%read(1013); 
%read(1014);
 
%read(1021); 
%read(1022);  
%read(1023); 
%read(1024);
 
%read(1031);
%read(1032);
%read(1033); 
%read(1034);   
      
%read(1041);
%read(1042);
%read(1043);
%read(1044);
%read(1045);
 
%read(1051);
%read(1052);
%read(1053);
%read(1054);
 
%read(1061);
%read(1062);
%read(1063);
%read(1064);
 
%read(1071);
%read(1072);
%read(1073);
%read(1074);
 
%read(1081);
%read(1082);
%read(1083); 
%read(1084);

%read(1091);
%read(1092);
%read(1093); 
%read(1094);

%read(1101);
%read(1102);
%read(1103); 
%read(1104);


%read2(1111);
%read2(1112);
%read2(1113); 
%read2(1114);
%read2(1115);




******* DELETE OBS IN 955 THAT ARE ALSO IN 961 ****;
PROC SORT DATA=out_h955;
   BY newid;
RUN;
PROC SORT DATA=out_h961;
   BY newid;
RUN;

DATA temp;
  SET out_h961;
  BY newid;
  IF first.newid;
RUN;

DATA out_h955; 
  MERGE out_h955(IN=in1) temp(IN=in2);
  BY newid; 
  if in2 THEN dat2=1;
  else dat2=0;
  IF in1;
  IF dat2=1 THEN DELETE;
RUN; 


******* DELETE OBS IN 045 THAT ARE ALSO IN 051 ****;
PROC SORT DATA=out_h1045;
   BY newid;
RUN;

PROC SORT DATA=out_h1051;
   BY newid;
RUN;

DATA temp;
SET out_h1051;
BY newid;
IF first.newid;
RUN;
DATA out_h1045; 
MERGE out_h1045(IN=in1) temp(IN=in2);
BY newid; 
if in2 THEN dat2=1;
else dat2=0;
IF in1;
IF dat2=1 THEN DELETE;
RUN; 


DATA alldat.home_val8411;
SET 
  out_h841 out_h842 out_h843 out_h844 
	out_h851 out_h852 out_h853 out_h854 
	out_h861 out_h862 out_h863 out_h864 
	out_h871 out_h872 out_h873 out_h874 
	out_h881 out_h882 out_h883 out_h884 
	out_h891 out_h892 out_h893 out_h894 
	out_h901 out_h902 out_h903 out_h904 
	out_h911 out_h912 out_h913 out_h914 
	out_h921 out_h922 out_h923 out_h924 
	out_h931 out_h932 out_h933 out_h934 
	out_h941 out_h942 out_h943 out_h944 
	out_h951 out_h952 out_h953 out_h954 out_h955 
	out_h961 out_h962 out_h963 out_h964 
	out_h971 out_h972 out_h973 out_h974 
	out_h981 out_h982 out_h983 out_h984 
	out_h991 out_h992 out_h993 out_h994 
	out_h1001 out_h1002 out_h1003 out_h1004 
	out_h1011 out_h1012 out_h1013 out_h1014 
	out_h1021 out_h1022 out_h1023 out_h1024 
	out_h1031 out_h1032 out_h1033 out_h1034 
	out_h1041 out_h1042 out_h1043 out_h1044 out_h1045 
	out_h1051 out_h1052 out_h1053 out_h1054 
	out_h1061 out_h1062 out_h1063 out_h1064 
	out_h1071 out_h1072 out_h1073 out_h1074 
	out_h1081 out_h1082 out_h1083 out_h1084
	out_h1091 out_h1092 out_h1093 out_h1094 
	out_h1101 out_h1102 out_h1103 out_h1104
	out_h1111 out_h1112 out_h1113 out_h1114 out_h1115;
KEEP newid n_hous totpval qyear;
*IF n_hous=3;
  
* n_hous=3 means 1 house, n_hous =6 means 2 houses, etc.;
* propvalu=propvalu/n_hous*3;

RUN;

* NOTE VERIFY THAT N_HOUS IS A MULTIPLE OF 3;
PROC FREQ;
  TABLE n_hous;
RUN;

PROC MEANS DATA=alldat.home_val8411;
RUN;
PROC SORT DATA=alldat.home_val8411;
BY qyear;
PROC MEANS DATA=alldat.home_val8411;
BY qyear;
RUN;



